--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	"mental ray Gamma and Gain"
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	3088 --Texture
)
--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(0x7773161fL, 0x996c7d15L)
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	"Color Map"
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	3088 --Texture
)
--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x139f22c6L, 0x13f6a914L)
)
--Returns some information about this conversion script
--Should this be localized ?
fn AboutText =
(
	"Converts from a mental ray Gamma and Gain to a Color Map"
)
--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)
--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Internal function that does the parameter mapping
fn ConvertFrom_GammaAndGainToColorMap Source Dest =
(
	if ( false == VerifySource Source or 
		 false == VerifyDestination Dest
		) do
	(
		--Not the suitable nodes
		return undefined
	)
	
    Dest.name = Source.name
    
    Dest.solidcolor = Source.input
    if(Source.input.controller != undefined) do Dest.solidcolor.controller = Source.input.controller
    
    Dest.map = Source.input_shader
    Dest.mapEnabled = Source.input_connected
    
    Dest.gamma = Source.gamma
    if(Source.gamma.controller != undefined) do Dest.gamma.controller = Source.gamma.controller
    
    Dest.gain = Source.gain
    if(Source.gain.controller != undefined) do Dest.gain.controller = Source.gain.controller
    
    Dest.ReverseGamma = Source.reverse
    
	Dest
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion source /*Not use*/=
(
	--Create the destination texture map
	newMap = ColorMap()

	--return the new map
	newMap
)

--Main entry point from this script
--This function handles the texture map creation
fn Conversion gammaAndGainMap =
(
	if (false == VerifySource gammaAndGainMap)  do
	(
		--Not the suitable node
		return undefined
	)
	
	--Create the destination texture map
	newMap = ColorMap()
	
	--Call the parameters mapping function to convert
	ConvertFrom_GammaAndGainToColorMap gammaAndGainMap newMap
	
	--return the new map
	newMap
)
